const conexion = require('../database/db');
const bcryptjs = require('bcryptjs');

const nuevoUsuario = async(datos)=>{
    try {
        var { nombre, username, contra } = datos;

        var passEncr = await bcryptjs.hash(contra, 8);

        await conexion.query('INSERT INTO tbl_usuarios SET ?',{
            db_nombre: nombre,
            db_username: username,
            db_clave: passEncr,
            db_estado: 1,
            db_asignacion: ''
        });

        return {
            statusCode: 200,
            estado: 'Correcto',
            mensaje: 'Usuario registrado',
            icon: 'success'
        }
    } catch (error) {
        console.log(error);

        return {
            statusCode: 400,
            estado: 'Error',
            mensaje: error.message,
            icon: 'error'
        }
    }
}



module.exports = {
    nuevoUsuario
}