const conexion = require('../database/db');
const jwt = require('jsonwebtoken');
const bcryptjs = require('bcryptjs');
const {promisify} = require('util');


const iniciarSession = async(datos)=>{
    try {
        var { username, contra } = datos;

        var [resultado] = await conexion.query('SELECT * FROM tbl_usuarios WHERE db_username = ?', [username]);

        if(resultado.length === 0){
            return {statusCode: 200, estado: 'Fallido', mensaje: 'Nombre de usuario incorrecto', icon: 'info'}
        }else{
            if(!(await bcryptjs.compare(contra, resultado[0].db_clave))){

                return {statusCode: 200, estado: 'Fallido', mensaje: 'Contrasenia incorrecta', icon: 'info'}

            }else{
                const ID = resultado[0].id
                const token = jwt.sign({id: ID }, process.env.JWT_SECRETO, {
                    expiresIn: process.env.JWT_TIEMPO_EXPIRA
                });

                console.log("Token: "+ token + " Para el usuario: "+username);

                const cookiesOptions = {
                    expires: new Date(Date.now() + process.env.JWT_COOKIE_EXPIRES * 24 * 60 * 1000),
                    httpOnly: true
                };

                return {
                    statusCode: 200,
                    estado: "Iniciado",
                    mensaje: 'Sesion Iniciada correctamente',
                    icon: 'success',
                    token: token,
                    cookies: cookiesOptions
                }

            }
        }

        return {statusCode: 200, estado: 'Iniciado', mensaje: 'Sesion iniciada correctamente', icon: 'success'}
    } catch (error) {
        console.log(error);
        return {
            statusCode: 400, estado: 'Error', mensaje: error.messagge, icon: 'error'
        }
    }
}

const verificarSesion = async(datos)=>{
    try {
        if(datos.carteraToken){
            const usuario = await promisify(jwt.verify)(datos.carteraToken, process.env.JWT_SECRETO);
            const [resultado] = await conexion.query('SELECT * FROM tbl_usuarios WHERE id = ?', usuario.id);

            if(!resultado){
                return {status: 0, mensaje: 'Sesion expirada', Usuario: []}
            }

            return {status: 1, mensaje: 'Sesion activa', Usuario: resultado[0]}
            
        }else{
            return {status: 0, mensaje: 'Sesion expirada'}
        }
    } catch (error) {

        console.log(error.message);
        return {status: 0, mensaje: 'Sesion expirada'}
    }
}

module.exports = {
    iniciarSession,
    verificarSesion
}