const conexion = require('../database/db');


const directorioClientes = async()=>{
    try {
        var [clientes] = await conexion.query('SELECT id, db_nombre, db_telefono, CASE WHEN db_estado = 1 THEN "Activo" ELSE "Inactivo" END AS db_estado FROM tbl_clientes');

        return clientes;
    } catch (error) {
        return [];
    }
}

const nuevoCliente = async(datos)=>{
    try {
        var { cliente, ctelefono } = datos;

        await conexion.query('INSERT INTO tbl_clientes SET ?', {
            db_nombre: cliente,
            db_telefono: ctelefono,
            db_estado: 1
        });

        return {
            statusCode: 200,
            estado: 'Correcto',
            mensaje: 'Cliente registrado correctamente',
            icon: 'success'
        }
    } catch (error) {
        console.log(error);
        return {
            statusCode: 400,
            estado: 'error',
            mensaje: error.messagge,
            icon: 'error'
        }
    }
}

const editarCliente = async(datos)=>{
    try {
        var {cliente2, telefono, idCliente, estado } = datos

        await conexion.query('UPDATE tbl_clientes SET ? WHERE id = ?', [{
            db_nombre: cliente2,
            db_telefono: telefono,
            db_estado: estado
        }, idCliente]);

        return {
            statusCode: 200,
            estado: 'Correcto',
            mensaje: 'Cliente actualizado correctamente',
            icon: 'success'
        }
    } catch (error) {
        return {
            statusCode: 400,
            estado: 'error',
            mensaje: error.message,
            icon: 'error'
        }
    }
}


module.exports = {
    directorioClientes,
    nuevoCliente,
    editarCliente
}