const conexion = require('../database/db');

const directorioCarteras = async()=>{
    try {
        var [carteras] = await conexion.query('SELECT C.id, Cl.db_nombre AS Cliente, C.db_saldo, C.db_fechacreacion FROM tbl_cartera AS C INNER JOIN tbl_clientes AS Cl ON C.db_cliente = Cl.id');


        return carteras;

    } catch (error) {
        console.log(error);
        return [];
    }
}

const nuevaCartera = async(datos, usuario)=>{
    try {

        var { Cliente, Saldo } = datos

        await conexion.query('INSERT INTO tbl_cartera SET ?', {
            db_cliente: Cliente,
            db_saldo: Saldo,
            db_usuario: usuario.id
        });

        return {
            statusCode: 200,
            estado: "Correcto",
            mensaje: 'Cartera registrada exitosamente',
            icon: 'success'
        }
        
    } catch (error) {
        return {
            statusCode: 400,
            estado: 'Error',
            mensaje: error.message,
            icon: 'error'
        }
    }
}


module.exports = {
    directorioCarteras,
    nuevaCartera
}