const conexion = require('../database/db');


const nuevoAbono = async(datos, usuario)=>{
    try {
        var {Cliente, Banco, tipoPago, Pago, Comentario} = datos
        var {id} = usuario

        var [verificar] = await conexion.query('SELECT db_saldo FROM tbl_cartera WHERE db_cliente = ?', [Cliente]);

        if(verificar[0].db_saldo === 0){
            return {
                statusCode: 200,
                estado: 'Alto!',
                mensaje: 'El cliente ya ha liquidado su cuenta, el pago no puede ser aplicado',
                icon: 'info'
            }
        }else{
            await conexion.query('INSERT INTO tbl_abonos SET ? ', {
                db_cliente: Cliente,
                db_banco: Banco,
                db_tipopago: tipoPago, 
                db_pago: Pago,
                db_usuario: id,
                db_comentario: Comentario
            });

            await conexion.query('UPDATE tbl_cartera SET db_saldo = db_saldo - ? WHERE db_cliente = ?', [Pago, Cliente]);

            return {
                statusCode: 200,
                estado: 'Correcto!',
                mensaje: 'Pago registrado correctamente',
                icon: 'success'
            }
        }
        

        
    } catch (error) {
        console.log(error)
        return {
            statusCode: 200,
            estado: 'Error!',
            mensaje: error.message,
            icon: "error"
        }
    }
}


const registroPagos = async()=>{
    try {
        var [abonos] = await conexion.query('SELECT A.id, C.db_nombre AS Cliente, B.db_banco AS Banco, CASE WHEN db_tipopago = 1 THEN "Efectivo" WHEN db_tipopago = 2 THEN "Tarjeta de credito" WHEN db_tipopago = 3 THEN "Tarjeta de credito" WHEN db_tipopago = 4 THEN "Transferencia electronica de fondos" WHEN db_tipopago = 5 THEN "Comisiones" ELSE "Nota de credito" END AS Tipopago, U.db_nombre AS Usuario, A.db_comentario, A.db_fecha, A.db_pago FROM tbl_abonos AS A INNER JOIN tbl_clientes AS C ON A.db_cliente = C.id INNER JOIN tbl_bancos AS B ON A.db_banco = B.id INNER JOIN tbl_usuarios AS U ON A.db_usuario = U.id');
        return abonos
    } catch (error) {
        console.log(error);
        return []
    }
}


module.exports = {
    nuevoAbono,
    registroPagos
}