const form = document.getElementById('registrarCliente');
const edicionForm = document.getElementById('edicionCliente1');



form.addEventListener("submit", (event) =>{
    event.preventDefault();
    guardarUser();
});

edicionForm.addEventListener("submit", (event) =>{
    event.preventDefault();
    editarCliente();
})


async function guardarUser(){
      
        try {
          const formData = new FormData(form);

          const datos = new URLSearchParams(formData);


            const response = await fetch("/servicios-clientes/nuevo", {
              method: "POST",
              body: datos,
            });

          var datosres = await response.json()
          console.log(datosres);

          Swal.fire({
            title: datosres.estado,
            text: datosres.mensaje,
            icon: datosres.icon
          }).then(()=>{
            window.location.reload()
          });
            
          

        } catch (error) {
            console.log(error.messagge);
            Swal.fire({
              title: 'Error',
              text: error.messagge,
              icon: 'error'
            });
        }
}

async function editarCliente(){
      
        try {
          const formData = new FormData(edicionForm);

          const datos = new URLSearchParams(formData);


            const response = await fetch("/servicios-clientes/edicion", {
              method: "POST",
              body: datos,
            });

          var datosres = await response.json()
          console.log(datosres);

          Swal.fire({
            title: datosres.estado,
            text: datosres.mensaje,
            icon: datosres.icon
          }).then(()=>{
            window.location.reload()
          });
            
          

        } catch (error) {
            console.log(error.messagge);
            Swal.fire({
              title: 'Error',
              text: error.messagge,
              icon: 'error'
            });
        }
}

function agregarEdicion(id, nombre, telefono){
    $('#editarCliente').modal('show');

    document.getElementById("cliente2").value = nombre
    document.getElementById("telefono").value = telefono
    document.getElementById('idCliente').value = id
}