const express = require('express');
const dotenv = require('dotenv');
const app = express();
const bodyParser = require('body-parser');
const path = require('path');
const cookieParser = require('cookie-parser');


app.set('view engine', "ejs");
app.set("views", path.join(__dirname, "src", "views"));
//app.use(express.static("src/public"));
app.use(express.static(path.join(__dirname, "src", "public")));

app.use(bodyParser.json({ limit: "50mb" }));
app.use(express.urlencoded({ extended: true }));
app.use(express.json());

dotenv.config({ path: "./src/env/.env" });

app.use(cookieParser());
const index = require('./src/routes/index');
const usuarios = require('./src/routes/usuarios');
const home = require('./src/routes/home');
const clientes = require('./src/routes/clientes');
const carteras = require('./src/routes/cartera');
const abonos = require('./src/routes/abono');

app.use("/", index);
app.use("/servicios-usuarios", usuarios);
app.use('/servicios-sesion', index);
app.use('/home', home);
app.use('/servicios-clientes', clientes);
app.use('/servicios-cartera', carteras);
app.use('/servicios-abonos', abonos);


app.listen(process.env.PORT, ()=>{
    console.log("Iniciado");
})